<?php
// edit_marks.php
session_start();
if(!isset($_SESSION['teacher_id'])){
    echo "Not authorized";
    exit;
}
$tid = $_SESSION['teacher_id'];

$teach = mysqli_connect("localhost","thevkin_schlteachdb","VK_AutSchlDb","thevkin_schlteachdb");
$core  = mysqli_connect("localhost","thevkin_schlcoredb","VK_AutSchlDb","thevkin_schlcoredb");
if(!$teach || !$core) die("DB Error");

$mark_id = $_GET['mark_id'] ?? '';
if(!$mark_id) {
    echo "Mark ID required";
    exit;
}

$mark = mysqli_fetch_assoc(mysqli_query($core,"SELECT * FROM marks WHERE id='".mysqli_real_escape_string($core,$mark_id)."'"));
if(!$mark) {
    echo "Mark not found";
    exit;
}

$student = mysqli_fetch_assoc(mysqli_query($core,"SELECT * FROM students WHERE id='".mysqli_real_escape_string($core,$mark['student_id'])."'"));
$subject = mysqli_fetch_assoc(mysqli_query($core,"SELECT * FROM subjects WHERE id='".mysqli_real_escape_string($core,$mark['subject_id'])."'"));

$msg = "";
if(isset($_POST['save'])){
    $new_marks = intval($_POST['marks']);
    mysqli_query($core,"UPDATE marks SET marks=$new_marks WHERE id='".mysqli_real_escape_string($core,$mark_id)."'");
    $msg = "success|Marks updated successfully";
    $mark['marks'] = $new_marks;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Edit Marks - TheVK School</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif;
    background: #f3f4f6;
    padding: 20px;
}

.edit-container {
    max-width: 600px;
    margin: 0 auto;
}

.header {
    display: flex;
    align-items: center;
    gap: 16px;
    margin-bottom: 24px;
}

.back-btn {
    width: 40px;
    height: 40px;
    background: white;
    border: 1px solid #e5e7eb;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.2s ease;
    text-decoration: none;
}

.back-btn:hover {
    background: #f9fafb;
    transform: translateX(-2px);
}

.back-btn svg {
    width: 20px;
    height: 20px;
    color: #374151;
}

.header h1 {
    font-size: 24px;
    color: #1f2937;
}

.alert {
    padding: 16px 20px;
    border-radius: 12px;
    margin-bottom: 24px;
    display: flex;
    align-items: center;
    gap: 12px;
    animation: slideIn 0.3s ease;
    background: #d1fae5;
    color: #065f46;
    border: 1px solid #a7f3d0;
}

@keyframes slideIn {
    from {
        opacity: 0;
        transform: translateY(-10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.alert svg {
    flex-shrink: 0;
}

.info-card {
    background: white;
    padding: 24px;
    border-radius: 12px;
    margin-bottom: 24px;
    border: 1px solid #e5e7eb;
}

.info-grid {
    display: grid;
    gap: 16px;
}

.info-item {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.info-label {
    font-size: 13px;
    color: #6b7280;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.info-value {
    font-size: 16px;
    color: #1f2937;
}

.edit-card {
    background: white;
    padding: 28px;
    border-radius: 12px;
    border: 1px solid #e5e7eb;
}

.form-group {
    margin-bottom: 24px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    color: #374151;
    font-size: 14px;
}

.form-input {
    width: 100%;
    padding: 14px 16px;
    border: 2px solid #e5e7eb;
    border-radius: 10px;
    font-size: 16px;
    transition: all 0.2s ease;
    font-family: 'Inter', sans-serif;
}

.form-input:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
}

.form-footer {
    display: flex;
    gap: 12px;
}

.btn {
    padding: 12px 24px;
    border: none;
    border-radius: 10px;
    cursor: pointer;
    font-size: 15px;
    transition: all 0.3s ease;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}

.btn-primary {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
    box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);
    flex: 1;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(16, 185, 129, 0.4);
}

.btn-secondary {
    background: #f3f4f6;
    color: #374151;
}

.btn-secondary:hover {
    background: #e5e7eb;
}

@media (max-width: 768px) {
    body {
        padding: 12px;
    }
    
    .header h1 {
        font-size: 20px;
    }
}
</style>
</head>
<body>

<div class="edit-container">
    <div class="header">
        <a href="teacher_dashboard.php?page=view_marks" class="back-btn">
            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <line x1="19" y1="12" x2="5" y2="12"/>
                <polyline points="12 19 5 12 12 5"/>
            </svg>
        </a>
        <h1>Edit Marks</h1>
    </div>
    
    <?php if($msg): 
        list($type, $text) = explode('|', $msg);
    ?>
    <div class="alert">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/>
            <polyline points="22 4 12 14.01 9 11.01"/>
        </svg>
        <span><?php echo htmlspecialchars($text); ?></span>
    </div>
    <?php endif; ?>
    
    <div class="info-card">
        <div class="info-grid">
            <div class="info-item">
                <div class="info-label">Student Name</div>
                <div class="info-value"><?php echo htmlspecialchars($student['name']); ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">Subject</div>
                <div class="info-value"><?php echo htmlspecialchars($subject['name']); ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">Term</div>
                <div class="info-value"><?php echo htmlspecialchars($mark['term']); ?></div>
            </div>
        </div>
    </div>
    
    <form method="post" class="edit-card">
        <div class="form-group">
            <label for="marks">Marks (0-100)</label>
            <input 
                type="number" 
                id="marks"
                name="marks" 
                class="form-input" 
                value="<?php echo htmlspecialchars($mark['marks']); ?>" 
                min="0" 
                max="100" 
                required
                autofocus
            >
        </div>
        
        <div class="form-footer">
            <button type="submit" name="save" class="btn btn-primary">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" width="18" height="18">
                    <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/>
                    <polyline points="17 21 17 13 7 13 7 21"/>
                    <polyline points="7 3 7 8 15 8"/>
                </svg>
                Update Marks
            </button>
            <a href="teacher_dashboard.php?page=view_marks" class="btn btn-secondary">Cancel</a>
        </div>
    </form>
</div>

</body>
</html>
