<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

/* ======================
    LOGIN CHECK
====================== */
if (!isset($_SESSION['teacher_id'])) {
    header("Location: teacher_login.php");
    exit;
}

$teacher_id     = $_SESSION['teacher_id'];
$teacher_name = $_SESSION['teacher_name'];

/* ======================
    DB CONNECTIONS
====================== */
$teacherDB = mysqli_connect("localhost","thevkin_schlteachdb","VK_AutSchlDb","thevkin_schlteachdb");
$coreDB    = mysqli_connect("localhost","thevkin_schlcoredb","VK_AutSchlDb","thevkin_schlcoredb");

/* ======================
    GET TEACHER SCHOOL
====================== */
$teacher_school = '';
$q = mysqli_query($teacherDB,
    "SELECT created_by FROM teacher_profiles WHERE id = $teacher_id LIMIT 1"
);
if ($r = mysqli_fetch_assoc($q)) {
    $teacher_school = $r['created_by'];
}

/* ======================
    ACADEMIC YEARS
====================== */
$academicYears = [];
$res = mysqli_query($coreDB,
    "SELECT id, Year
     FROM academic_years
     WHERE created_by = '$teacher_school'
     ORDER BY Year DESC"
);
while ($r = mysqli_fetch_assoc($res)) {
    $academicYears[] = $r;
}

$selected_ay      = $_POST['academic_year'] ?? '';
$selected_class   = $_POST['class_id'] ?? '';
$selected_subject = $_POST['subject_id'] ?? '';

/* ======================
    ASSIGNED CLASSES
====================== */
$assigned_class_ids = [];

if ($selected_ay) {
    $q1 = mysqli_query($teacherDB,
        "SELECT class_id FROM teacher_class_assignments
         WHERE teacher_profile_id = $teacher_id
         AND academic_year_id = $selected_ay"
    );
    while ($r = mysqli_fetch_assoc($q1)) $assigned_class_ids[] = $r['class_id'];

    $q2 = mysqli_query($teacherDB,
        "SELECT class_id FROM teacher_subject_assignments
         WHERE teacher_profile_id = $teacher_id
         AND academic_year_id = $selected_ay"
    );
    while ($r = mysqli_fetch_assoc($q2)) $assigned_class_ids[] = $r['class_id'];

    $assigned_class_ids = array_unique($assigned_class_ids);
}

$classes = [];
if ($assigned_class_ids) {
    $ids = implode(',', $assigned_class_ids);
    $q = mysqli_query($coreDB,
        "SELECT id, name FROM classes WHERE id IN ($ids)"
    );
    while ($r = mysqli_fetch_assoc($q)) $classes[] = $r;
}

/* ======================
    ROLE DETECTION
====================== */
$is_class_teacher   = false;
$is_subject_teacher = false;

if ($selected_class) {
    $q = mysqli_query($teacherDB,
        "SELECT 1 FROM teacher_class_assignments
         WHERE teacher_profile_id = $teacher_id
         AND class_id = $selected_class
         AND is_class_teacher = 1 LIMIT 1"
    );
    if (mysqli_num_rows($q)) $is_class_teacher = true;

    $q = mysqli_query($teacherDB,
        "SELECT 1 FROM teacher_subject_assignments
         WHERE teacher_profile_id = $teacher_id
         AND class_id = $selected_class LIMIT 1"
    );
    if (mysqli_num_rows($q)) $is_subject_teacher = true;
}

/* ======================
    SUBJECTS
====================== */
$subjects = [];

if ($selected_class && $is_subject_teacher) {

    // 1️⃣ Subjects assigned to this teacher
    $assigned_subjects = [];
    $q = mysqli_query($teacherDB,
        "SELECT subject_id FROM teacher_subject_assignments
         WHERE teacher_profile_id = $teacher_id
         AND class_id = $selected_class"
    );
    while ($r = mysqli_fetch_assoc($q)) {
        $assigned_subjects[] = $r['subject_id'];
    }

    if ($assigned_subjects) {

        // 2️⃣ Subjects already saved TODAY
        $saved_subjects = [];
        $today = date('Y-m-d');

        $q2 = mysqli_query($coreDB,
            "SELECT subject_id FROM homework
             WHERE class_id = '$selected_class'
             AND academic_year = '$selected_ay'
             AND homework_date = '$today'
             AND subject_id IS NOT NULL"
        );
        while ($r = mysqli_fetch_assoc($q2)) {
            $saved_subjects[] = $r['subject_id'];
        }

        // 3️⃣ Remove already saved subjects
        $remaining_subjects = array_diff($assigned_subjects, $saved_subjects);

        if ($remaining_subjects) {
            $ids = implode(',', $remaining_subjects);
            $qs = mysqli_query($coreDB,
                "SELECT id, subject_name
                 FROM subjects
                 WHERE id IN ($ids)"
            );
            while ($r = mysqli_fetch_assoc($qs)) {
                $subjects[] = $r;
            }
        }
    }
}


/* ======================
    SAVE HOMEWORK
====================== */
$success = "";

if (isset($_POST['save_homework'])) {

    $hw_text = mysqli_real_escape_string($coreDB, $_POST['homework_text']);
    $due_date = $_POST['due_date'];
    $hw_date  = date('Y-m-d');
    $subject_id = !empty($_POST['subject_id']) ? $_POST['subject_id'] : NULL;
    $img_path = NULL;

    if (!empty($_FILES['homework_image']['name'])) {
        $folder = "uploads/homework/";
        if (!is_dir($folder)) mkdir($folder, 0777, true);
        $img_path = $folder.time()."_".basename($_FILES['homework_image']['name']);
        move_uploaded_file($_FILES['homework_image']['tmp_name'], $img_path);
    }

    mysqli_query($coreDB,
        "INSERT INTO homework
         (academic_year, class_id, subject_id, homework_text, homework_image,
          homework_date, due_date, createdby)
         VALUES
         ('$selected_ay','$selected_class',
         ".($subject_id?"'$subject_id'":"NULL").",
         '$hw_text','$img_path','$hw_date','$due_date','$teacher_id')"
    );

    /* ===== Notification (ONLY when teacher confirms) ===== */
    if ($is_class_teacher && isset($_POST['send_notification'])) {

        $q = mysqli_query($coreDB,"
            SELECT DISTINCT s.subject_name
            FROM homework h
            LEFT JOIN subjects s ON s.id = h.subject_id
            WHERE h.class_id='$selected_class'
              AND h.academic_year='$selected_ay'
              AND h.homework_date='$hw_date'
        ");

        $list=[];
        while($r=mysqli_fetch_assoc($q)){
            if($r['subject_name']) $list[]=$r['subject_name'];
        }

        $message = $list
            ? "Homework updated for today in: ".implode(', ',$list)
            : "Homework updated for today.";

        $chk = mysqli_query($coreDB,"
            SELECT id FROM notification_homework
            WHERE academic_year_id='$selected_ay'
              AND class_id='$selected_class'
              AND created_by='$teacher_id'
              AND DATE(created_at)=CURDATE()
        ");

        if(mysqli_num_rows($chk)){
            $row=mysqli_fetch_assoc($chk);
            mysqli_query($coreDB,"
                UPDATE notification_homework
                SET message='$message'
                WHERE id='{$row['id']}'
            ");
        } else {
            mysqli_query($coreDB,"
                INSERT INTO notification_homework
                (academic_year_id,class_id,title,message,created_by)
                VALUES
                ('$selected_ay','$selected_class',
                 'New Homework Assigned','$message','$teacher_id')
            ");
        }
    }

    /* ===== Success message ===== */
    $q = mysqli_query($coreDB,"
        SELECT DISTINCT s.subject_name
        FROM homework h
        LEFT JOIN subjects s ON s.id=h.subject_id
        WHERE h.class_id='$selected_class'
          AND h.academic_year='$selected_ay'
          AND h.homework_date='$hw_date'
    ");

    $saved=[];
    while($r=mysqli_fetch_assoc($q)){
        if($r['subject_name']) $saved[]=$r['subject_name'];
    }

    $success = $saved
        ? "Homework saved for today: <b>".implode(', ',$saved)."</b> ✅"
        : "Class-wide homework saved for today ✅";
}
?>

<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Assign Homework</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
body{font-family:Inter;background:#f3f4f6}
.container{max-width:1100px;margin:30px auto}
.header{background:linear-gradient(135deg,#2563eb,#1e40af);color:#fff;padding:25px;border-radius:12px;margin-bottom:25px}
.card{background:#fff;padding:20px;border-radius:12px;margin-bottom:25px}
.row{display:flex;gap:20px;flex-wrap:wrap}
.col{flex:1;min-width:220px}
input,select,textarea{width:100%;padding:10px;border:1px solid #d1d5db;border-radius:8px}
.btn{background:#16a34a;color:#fff;padding:12px 22px;border:none;border-radius:8px;cursor:pointer}
.checkbox-row {
    margin-top: 15px;
}

.checkbox-label {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    font-size: 15px;
    cursor: pointer;
}

.checkbox-label input[type="checkbox"] {
    width: 18px;
    height: 18px;
    cursor: pointer;
}

</style>
</head>

<body>
<div class="container">

<div class="header">
<h2>Assign Homework</h2>
<p>Welcome, <b><?=htmlspecialchars($teacher_name)?></b></p>
</div>

<form method="post" enctype="multipart/form-data">

<div class="card">
<div class="row">

<div class="col">
<label>Academic Year</label>
<select name="academic_year" onchange="this.form.submit()" required>
<option value="">-- Select Academic Year --</option>
<?php foreach($academicYears as $ay): ?>
<option value="<?=$ay['id']?>" <?=($selected_ay==$ay['id'])?'selected':''?>>
<?=$ay['Year']?>
</option>
<?php endforeach; ?>
</select>
</div>

<div class="col">
<label>Class</label>
<select name="class_id" onchange="this.form.submit()" <?php echo empty($selected_ay)?'disabled':''; ?>>
<option value="">-- Select Class --</option>

<?php if (!empty($classes)): ?>
    <?php foreach ($classes as $c): ?>
        <option value="<?php echo $c['id']; ?>"
            <?php if ($selected_class == $c['id']) echo 'selected'; ?>>
            <?php echo $c['name']; ?>
        </option>
    <?php endforeach; ?>
<?php endif; ?>

</select>

<?php if ($selected_ay && empty($classes)): ?>
<p style="color:#b91c1c; margin-top:6px; font-size:14px;">
⚠ No classes assigned for this academic year
</p>
<?php endif; ?>

</div>

<?php if ($selected_class && $is_subject_teacher): ?>
<div class="col">
<label><?php echo $is_class_teacher ? 'Subject (optional)' : 'Select Subject'; ?></label>

<?php if (!empty($subjects)): ?>

    <select name="subject_id" <?php echo !$is_class_teacher ? 'required' : ''; ?>>
        <?php if ($is_class_teacher): ?>
            <option value="">-- Class-wide homework --</option>
        <?php else: ?>
            <option value="">-- Select Subject --</option>
        <?php endif; ?>

        <?php foreach ($subjects as $s): ?>
            <option value="<?php echo $s['id']; ?>">
                <?php echo $s['subject_name']; ?>
            </option>
        <?php endforeach; ?>
    </select>

<?php else: ?>

    <p style="color:green; margin-top:10px; font-weight:500;">
        ✅ All subject homeworks have been submitted for today
    </p>

<?php endif; ?>

</div>
<?php endif; ?>


</div>
</div>

<div class="card">

<h3>Homework Details</h3>

<?php
$today_display = date('d F Y');
?>
<p style="margin:6px 0 14px 0; color:#374151; font-size:14px;">
📅 <b>Homework Date:</b> <?php echo $today_display; ?> (Today)
</p>

<label>Homework Text</label>
<textarea name="homework_text" required></textarea><br><br>


<label>Homework Image</label>
<input type="file" name="homework_image"><br><br>

<label>Due Date</label>
<input type="date" name="due_date" value="<?=date('Y-m-d')?>" required>

<?php if($is_class_teacher): ?>
<div class="checkbox-row">
    <label class="checkbox-label">
        <input type="checkbox" name="send_notification" id="send_notification">
        <span>I have completed today’s homework – send notification</span>
    </label>
</div>

<?php endif; ?>

<br>
<button class="btn" name="save_homework">Save Homework</button>

<?php if($success): ?>
<p style="color:green;margin-top:10px"><?=$success?></p>
<?php endif; ?>

</div>
</form>
</div>
</body>
</html>